/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWArrayEditorTableModel
extends AbstractTableModel {
    private final int NUM_COLUMNS = 2;
    public static final int COL_INDEX = 0;
    public static final int COL_EXPRESSION = 1;
    private Vector m_rowData = null;
    private String m_expression = null;
    private int m_index = 1;
    private String m_arrayString = null;
    private String[] m_stringArray = null;

    public VWArrayEditorTableModel() {
        try {
            this.m_rowData = new Vector();
            this.m_expression = new String();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(String[] stringArray) {
        this.m_stringArray = stringArray;
    }

    public void addItem(String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        this.m_rowData.addElement(defaultValue);
        int newRowIndex = this.m_rowData.size() - 1;
        this.fireTableRowsInserted(newRowIndex, newRowIndex);
    }

    public void copyItem(int nRowIndex) {
    }

    public void deleteItem(int nRowIndex) {
        try {
            String expression = this.getItemAt(nRowIndex);
            if (expression != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize() {
        try {
            int size;
            this.m_rowData.removeAllElements();
            if (this.m_stringArray != null && (size = this.m_stringArray.length) > 0) {
                for (int i = 0; i < size; ++i) {
                    this.m_rowData.addElement(this.m_stringArray[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        String header = null;
        switch (nColumnIndex) {
            case 0: {
                header = "";
                break;
            }
            case 1: {
                header = VWResource.s_expressionStr;
            }
        }
        return header;
    }

    public Class getColumnClass(int nColumnIndex) {
        Class<String> columnClass = null;
        switch (nColumnIndex) {
            case 0: {
                columnClass = String.class;
                break;
            }
            case 1: {
                columnClass = String.class;
            }
        }
        return columnClass;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        String obj = null;
        try {
            switch (nColumnIndex) {
                case 0: {
                    obj = Integer.toString(nRowIndex + 1);
                    break;
                }
                case 1: {
                    obj = this.getItemAt(nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return obj;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 1: {
                    this.onUpdateExpression(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return nColumnIndex != 0;
    }

    private void onUpdateExpression(Object aValue, int nRowIndex) {
        try {
            String expression;
            String newExpression;
            if (aValue != null && aValue instanceof String && (newExpression = (String)aValue).length() > 0 && (expression = this.getItemAt(nRowIndex)) != null) {
                this.m_rowData.setElementAt(newExpression, nRowIndex);
                this.fireTableCellUpdated(nRowIndex, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String getItemAt(int nRowIndex) {
        String string = null;
        if (this.m_rowData != null && nRowIndex >= 0 && nRowIndex < this.m_rowData.size()) {
            string = (String)this.m_rowData.elementAt(nRowIndex);
        }
        return string;
    }

    public void up(int nRowIndex) {
        try {
            if (nRowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex - 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex - 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int nRowIndex) {
        try {
            if (nRowIndex < this.getRowCount() - 1) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex + 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex + 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String[] getStringArray() {
        Object[] resultArray = new String[this.m_rowData.size()];
        this.m_rowData.copyInto(resultArray);
        return resultArray;
    }
}

